import httpx, asyncio, random, os
from bs4 import BeautifulSoup
import functools
from concurrent.futures import ThreadPoolExecutor

class FileProgress:
    def __init__(self, path, callback, loop):
        self.file = open(path, 'rb')
        self.callback = callback
        self.loop = loop
        self.total = os.path.getsize(path)
        self.sent = 0

    def read(self, size=-1):
        chunk = self.file.read(size)
        if chunk:
            self.sent += len(chunk)
            if self.callback:
                self.loop.call_soon(
                    lambda: asyncio.create_task(
                        self.callback(self.sent, self.total)
                    )
                )
        return chunk
    def __enter__(self):
        return self
    def __exit__(self, exc_type, exc_val, exc_tb):
        self.file.close()

class File:
    def __init__(self, name=None, fileID=None):
        self.name = name
        self.id = fileID

class Response:
        SuccessLogin, FailedLogin, SuccessSendFile, FailedSendFile, SuccessDeleteFile, FailedDeleteFile, NoExistFile, SuccessDownloadFile, FailedDownloadFile, SuccessListFiles, FailedListFiles = 200, 300, 201, 301, 202, 302, 404, 203, 303, 204, 304
        def __init__(self, text=None, file=None, listFiles=None, response=None):
            self.text = text
            self.file = file
            self.listFiles = listFiles
            self.response = response

class Client:
    url = "https://talleres.ucf.edu.cu"
    node = 49
    username = "luisernestorb95"
    password = "Luisito1995*"
    connected = False
    sess = httpx.AsyncClient(timeout=None)
    async def connect(self):
        form = await self.sess.get(f"{self.url}/login/indico/form")
        soup = BeautifulSoup(form.json()["html"], "html.parser")
        self.csrfToken = soup.find('input', {'name':'csrf_token'})['value']
        login = await self.sess.post(f"{self.url}/login", data={"csrf_token": self.csrfToken, "_provider": "indico", "identifier": self.username, "password": self.password}, follow_redirects=True)
        if "Cerrar sesión" in login.text:
            return Response(response=Response.SuccessLogin)
        else:
            return Response(response=Response.FailedLogin)
    async def listFiles(self):
        if not self.connected:
            response = await self.connect()
            if response is Response.SuccessLogin:
                self.connected = True
            elif response is Response.FailedLogin:
                return Response(response=Response.FailedLogin)
        page = await self.sess.get(f"{self.url}/event/{self.node}/manage/attachments/")
        try:
            soup = BeautifulSoup(page.text, 'html.parser')
            attachments = soup.select('a.attachment[data-attachment-id]')
        except:
            return Response(listFiles=[], response=Response.FailedListFiles)
        listFiles = []
        for a in attachments:
            name = a.get_text(strip=True)
            fileID = a.get('data-attachment-id')
            if name and fileID:
                listFiles.append(File(name=name, fileID=fileID))
        return Response(listFiles=listFiles, response=Response.SuccessListFiles)
    async def sendFile(self, path, callback=None):
        if not self.connected:
            response = await self.connect()
            if response is Response.SuccessLogin:
                self.connected = True
            elif response is Response.FailedLogin:
                return Response(response=Response.FailedLogin)
        loop = asyncio.get_running_loop()
        data = {
            "csrf_token": self.csrfToken,
            "__file_change_trigger": "added-file",
            "folder": "__None",
            "acl": "[]",
        }
        with FileProgress(path, callback, loop) as f:
            files = {"files": (os.path.basename(path), f, "application/octet-stream")}
            up = await self.sess.post(
                f"{self.url}/event/{self.node}/manage/attachments/add/files",
                data=data,
                files=files,
                follow_redirects=True
            )
        success = up.json()['success']
        attach = up.json()["attachment_list"]
        soup = BeautifulSoup(attach, 'html.parser')
        attachments = soup.select('a.attachment[data-attachment-id]')
        listFiles = []
        currentFile = None
        for a in attachments:
            name = a.get_text(strip=True)
            fileID = a.get('data-attachment-id')
            if name and fileID:
                listFiles.append(File(name=name, fileID=fileID))
                if name == os.path.basename(path):
                    currentFile = File(name=name, fileID=fileID)
        if success:
            return Response(file=currentFile, listFiles=listFiles, response=Response.SuccessSendFile)
        else:
            return Response(response=Response.FailedSendFile)
    async def deleteFile(self, fileID):
        if not self.connected:
            response = await self.connect()
            if response is Response.SuccessLogin:
                self.connected = True
            elif response is Response.FailedLogin:
                return Response(response=Response.FailedLogin)
        self.sess.headers.update({"X-Csrf-Token": self.csrfToken})
        dele = await self.sess.delete(f"{self.url}/event/{self.node}/manage/attachments/202/{fileID}/", follow_redirects=True)
        if "No se ha podido encontrar el ítem" in dele.text:
            return Response(response=Response.NoExistFile)
        success = dele.json()['success']
        attach = dele.json()["attachment_list"]
        soup = BeautifulSoup(attach, 'html.parser')
        attachments = soup.select('a.attachment[data-attachment-id]')
        listFiles = []
        for a in attachments:
            name = a.get_text(strip=True)
            fileID = a.get('data-attachment-id')
            if name and fileID and not name.startswith('data-'):
                listFiles.append(File(name=name, fileID=fileID))
        if success:
            return Response(listFiles=listFiles,response=Response.SuccessDeleteFile)
        else:
            return Response(response=Response.FailedDeleteFile)
    async def downloadFile(self, fileID, callback=None):
        if not self.connected:
            response = await self.connect()
            if response is Response.SuccessLogin:
                self.connected = True
            elif response is Response.FailedLogin:
                return Response(response=Response.FailedLogin)
        async with self.sess.stream("GET",f"{self.url}/event/{self.node}/attachments/202/{fileID}/file", follow_redirects=True) as streamo:
            streamo.raise_for_status()
            disposition = streamo.headers.get("Content-Disposition")
            if 'attachment' in disposition:
                name = disposition.split('attachment; filename="')[1].split('"')[0]
            elif 'inline' in disposition:
                name = disposition.split('inline; filename=')[1]
            else:
                name = f"{random.randint(1000000000,9999999999)}.noname"
            currentSize = 0
            totalSize = int(streamo.headers.get("Content-Length",0))
            with open(name, "wb") as wfile:
                async for chunk in streamo.aiter_bytes(chunk_size=8192):
                    wfile.write(chunk)
                    currentSize += 8192
                    if callback:
                        await callback(currentSize, totalSize)
        if currentSize >= totalSize:
            return Response(response=Response.SuccessDownloadFile)
        else:
            return Response(response=Response.FailedDownloadFile)