from bitnode import Client, Response
import asyncio

node = Client()
async def main():
    
    # LISTAR ARCHIVOS ----------------------
    
    files = await node.listFiles()
    response = files.response
    
    if response is Response.SuccessListFiles:
        for file in files.listFiles:
            print(f"{file.id} - {file.name}\n")
    elif response is Response.FailedListFiles:
        print("Error al subir archivo")
    elif response is Response.FailedLogin:
        print("No se pudo iniciar sesión")
    
    # SUBIR ARCHIVO -------------------------
    
    async def progress_callback(sent, total):
        print(f"\rSubiendo... {sent} / {total}")
    send = await node.sendFile("image.png", callback=progress_callback)
    response = send.response
    
    if response is Response.SuccessSendFile:
        print("Archivo subido")
        print(f"Nombre: {send.file.name}")
        print(f"ID: {send.file.id}\n")

        for file in send.listFiles:
            print(f"{file.id} - {file.name}\n")
    elif response is Response.FailedSendFile:
        print("Error al subir archivo")
    elif response is Response.FailedLogin:
        print("No se pudo iniciar sesión")
    
    # DESCARGAR ARCHIVO -----------------
    
    async def progress(current, total):
        print(f"Descargando... {current} / {total}")
    
    download = await node.downloadFile(send.file.id, callback=progress)
    response = download.response
    
    if response is Response.SuccessDownloadFile:
        print("Archivo descargado")
    elif response is Response.FailedDownloadFile:
        print("Error al descargar archivo")
    elif response is Response.FailedLogin:
        print("No se pudo iniciar sesión")
    
    # BORRAR ARCHIVO -------------------------
    
    delete = await node.deleteFile(send.file.id)
    response = delete.response
    
    if response is Response.SuccessDeleteFile:
        print("Archivo eliminado")
    elif response is Response.FailedDeleteFile:
        print("Error al eliminar archivo")
    elif response is Response.FailedLogin:
        print("No se pudo iniciar sesión")
    elif response is Response.NoExistFile:
        print("No existe ese archivo")

asyncio.run(main())