from bitnode import Client, Response
import asyncio

node = Client()
async def main():
    
    files = await node.listFiles()
    response = files.response
    
    if response is Response.SuccessListFiles:
        for file in files.listFiles:
            print(f"{file.id} - {file.name}")
            delete = await node.deleteFile(file.id)
            response = delete.response
            
            if response is Response.SuccessDeleteFile:
                print("Archivo eliminado")
            elif response is Response.FailedDeleteFile:
                print("Error al eliminar archivo")
            elif response is Response.FailedLogin:
                print("No se pudo iniciar sesión")
            elif response is Response.NoExistFile:
                print("No existe ese archivo")
             
            print("\n")
    elif response is Response.FailedListFiles:
        print("Error al subir archivo")
    elif response is Response.FailedLogin:
        print("No se pudo iniciar sesión")

asyncio.run(main())